//=============================================================================
// Yanfly Engine Plugins - Screen Resolution
// ScreenResolution.js
// Version: 1.00
//=============================================================================

var Imported = Imported || {};
Imported.ScreenResolution = true;

var Yanfly = Yanfly || {};
Yanfly.ScrRes = Yanfly.ScrRes || {};

//=============================================================================
 /*:
 * @plugindesc v1.00 Change your game's screen resolution to your liking!
 * @author Yanfly Engine Plugins
 *
 * @param Screen Width
 * @desc Adjusts the width of the screen.                           .
 * Default: 816
 * @default 816
 *
 * @param Screen Height
 * @desc Adjusts the height of the screen.                          .
 * Default: 624
 * @default 624
 *
 * @help
 * Adjust the parameters to change the size of how you want your game's
 * screen resolution to appear.
 */
//=============================================================================

Yanfly.Parameters = PluginManager.parameters('ScreenResolution');

//=============================================================================
// Scene_Manager
//=============================================================================

SceneManager._screenWidth  = Number(Yanfly.Parameters['Screen Width'] || 816);
SceneManager._screenHeight = Number(Yanfly.Parameters['Screen Height'] || 624);
SceneManager._boxWidth     = Number(Yanfly.Parameters['Screen Width'] || 816);
SceneManager._boxHeight    = Number(Yanfly.Parameters['Screen Height'] || 624);

Yanfly.ScrRes.SceneManager_run = SceneManager.run;
SceneManager.run = function(sceneClass) {
    Yanfly.ScrRes.SceneManager_run.call(this, sceneClass);
    if (Utils.isMobileDevice()) return;
    if (Utils.isMobileSafari()) return;
    if (Utils.isAndroidChrome()) return;
		var resizeWidth = Graphics.boxWidth - window.innerWidth;
		var resizeHeight = Graphics.boxHeight - window.innerHeight;
		window.moveBy(-1 * resizeWidth / 2, -1 * resizeHeight / 2);
		window.resizeBy(resizeWidth, resizeHeight);
};

//=============================================================================
// End of File
//=============================================================================












































































































































// Scene_Boot.prototype.start=function(){Scene_Base.prototype.start.call(this),SoundManager.preloadImportantSounds(),DataManager.isBattleTest()?(DataManager.setupBattleTest(),SceneManager["goto"](Scene_Battle)):DataManager.isEventTest()?(DataManager.setupEventTest(),SceneManager["goto"](Scene_Map)):(this.checkPlayerLocation(),DataManager.setupNewGame(),SceneManager["goto"](Scene_Map),""===StorageManager.load(1)&&DataManager.saveGame(1),loadVariables=JsonEx.parse(StorageManager.load(1)).variables,$gameVariables.setValue(2,loadVariables.value(2))),this.updateDocumentTitle(),Scene_Menu=Scene_GameEnd,Graphics._switchFullScreen()},Game_Player.prototype.isMapPassable=function(e,a,r,t){var i=$gameMap.roundXWithDirection(e,r),l=$gameMap.roundYWithDirection(a,r);return void 0===t&&(t=playerChar.lvl),cMyPassibility(i,l,t,r)},Scene_GameEnd.prototype.commandToTitle=function(){this.fadeOutAll(),DataManager.setupNewGame(),loadVariables=JsonEx.parse(StorageManager.load(1)).variables,$gameVariables.setValue(2,loadVariables.value(2)),SceneManager["goto"](Scene_Map)};var cMap={height:13,width:23},cPxl=48,allowMove=!0,pilarEvents=[],switchEvents=[],cTileEvents=[],blueSwitch={},purpleSwitch={},greenSwitch={},yellowSwitch={},cCountFreeSlot=0,allowSwap=!0,tileSelection=!1,tileControl=!1,cacheTile={},mapOrder=[],nbOfChar=4,swapMode=!1,chrono=0,retry=!1,i=0;Game_CharacterBase.prototype.canPass=function(e,a,r){var t=$gameMap.roundXWithDirection(e,r),i=$gameMap.roundYWithDirection(a,r);return $gameMap.isValid(t,i)?this.isThrough()||this.isDebugThrough()?!0:this.isMapPassable(e,a,r)?!0:!1:!1};var cIconSwitch={cImage:"swap",cPos:[48,72],cActive:!0,cImageId:1},cIconBlueChar={cImage:"perso_bleu",cPos:[40,168],cActive:!0,cImageId:2},cIconPurpleChar={cImage:"perso_violet",cPos:[16,190],cActive:!0,cImageId:3},cIconGreenChar={cImage:"perso_vert",cPos:[56,190],cActive:!0,cImageId:4},cIconYellowChar={cImage:"perso_jaune",cPos:[40,212],cActive:!0,cImageId:5},cIconSetTile={cImage:"column",cPos:[1056,72],cActive:!0,cImageId:6},cIconBlueTile={cImage:"dalle_bleu",cPos:[1056,168],cActive:!1,cImageId:7},cIconPurpleTile={cImage:"dalle_violet",cPos:[1056,264],cActive:!1,cImageId:8},cIconGreenTile={cImage:"dalle_vert",cPos:[1056,360],cActive:!1,cImageId:9},cIconYellowTile={cImage:"dalle_jaune",cPos:[1056,456],cActive:!1,cImageId:10},cIconJump={cImage:"jump",cPos:[1056,72],cActive:!1,cImageId:11},cIconCancel={cImage:"cancel",cPos:[1056,72],cActive:!1,cImageId:12},cIconConfirm={cImage:"ok",cPos:[1056,264],cActive:!1,cImageId:13},cIconUp={cImage:"up",cPos:[1056,168],cActive:!1,cImageId:14},cIconDown={cImage:"down",cPos:[1056,456],cActive:!1,cImageId:15},cIconRetry={cImage:"retry",cPos:[48,552],cActive:!0,cImageId:16},cIconSkip={cImage:"skip",cPos:[1056,552],cActive:!1,cImageId:17},wallDown={cImage:"wallDown",cPos:[96,576],cActive:!1,cImageId:18},cIconBlueTile0={cImage:"dalle_bleu",cPos:[1056,168],cActive:!1,cImageId:19},cIconPurpleTile0={cImage:"dalle_violet",cPos:[1056,264],cActive:!1,cImageId:20},cIconGreenTile0={cImage:"dalle_vert",cPos:[1056,360],cActive:!1,cImageId:21},cIconYellowTile0={cImage:"dalle_jaune",cPos:[1056,456],cActive:!1,cImageId:22},cGetId=function(e){for(var a=0;a<cMap.width;a++)for(var r=0;r<cMap.height;r++){var t=$gameMap.eventIdXy(a,r);if(t>0&&$dataMap.events[t].name===e)return t}},cGetPilars=function(){for(var e=0;e<cMap.width;e++)for(var a=0;a<cMap.height;a++){var r=$gameMap.eventIdXy(e,a);r>0&&"pilier"===$dataMap.events[r].name&&pilarEvents.push($gameMap.event(r)),r>0&&"switch"===$dataMap.events[r].name&&switchEvents.push($gameMap.event(r))}},cGetMapElements=function(){for(var e=0,a=0,r=0;r<cMap.width;r++)for(var t=0;t<cMap.height;t++){var i=$gameMap.tileId(r,t,3);switch(i){case 4:switchEvents[a].setPosition(r,t),switchEvents[a].set_frame("!dalle",5,1,2),switchEvents[a].setPriorityType(0),switchEvents[a].lvl=0,blueSwitch=switchEvents[a],a++;break;case 5:switchEvents[a].setPosition(r,t),switchEvents[a].set_frame("!dalle",5,2,2),switchEvents[a].setPriorityType(0),switchEvents[a].lvl=0,purpleSwitch=switchEvents[a],a++;break;case 6:switchEvents[a].setPosition(r,t),switchEvents[a].set_frame("!dalle",5,3,2),switchEvents[a].setPriorityType(0),switchEvents[a].lvl=0,greenSwitch=switchEvents[a],a++;break;case 7:switchEvents[a].setPosition(r,t),switchEvents[a].set_frame("!dalle",6,1,2),switchEvents[a].setPriorityType(0),switchEvents[a].lvl=0,yellowSwitch=switchEvents[a],a++;break;case 12:switchEvents[a].setPosition(r,t+1),switchEvents[a].set_frame("!dalle",5,1,4),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=1,blueSwitch=switchEvents[a],a++;break;case 13:switchEvents[a].setPosition(r,t+1),switchEvents[a].set_frame("!dalle",5,2,4),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=1,purpleSwitch=switchEvents[a],a++;break;case 14:switchEvents[a].setPosition(r,t+1),switchEvents[a].set_frame("!dalle",5,3,4),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=1,greenSwitch=switchEvents[a],a++;break;case 15:switchEvents[a].setPosition(r,t+1),switchEvents[a].set_frame("!dalle",6,1,4),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=1,yellowSwitch=switchEvents[a],a++;break;case 28:switchEvents[a].setPosition(r,t+2),switchEvents[a].set_frame("!dalle",5,1,6),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=2,blueSwitch=switchEvents[a],a++;break;case 29:switchEvents[a].setPosition(r,t+2),switchEvents[a].set_frame("!dalle",5,2,6),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=2,purpleSwitch=switchEvents[a],a++;break;case 30:switchEvents[a].setPosition(r,t+2),switchEvents[a].set_frame("!dalle",5,3,6),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=2,greenSwitch=switchEvents[a],a++;break;case 31:switchEvents[a].setPosition(r,t+2),switchEvents[a].set_frame("!dalle",6,1,6),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=2,yellowSwitch=switchEvents[a],a++;break;case 52:switchEvents[a].setPosition(r,t+3),switchEvents[a].set_frame("!dalle",5,1,8),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=3,blueSwitch=switchEvents[a],a++;break;case 53:switchEvents[a].setPosition(r,t+3),switchEvents[a].set_frame("!dalle",5,2,8),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=3,purpleSwitch=switchEvents[a],a++;break;case 54:switchEvents[a].setPosition(r,t+3),switchEvents[a].set_frame("!dalle",5,3,8),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=3,greenSwitch=switchEvents[a],a++;break;case 55:switchEvents[a].setPosition(r,t+3),switchEvents[a].set_frame("!dalle",6,1,8),switchEvents[a].setPriorityType(1),switchEvents[a].lvl=3,yellowSwitch=switchEvents[a],a++;break;case 8:pilarEvents[e].setPosition(r,t+1),pilarEvents[e].set_frame("!dalle",6,2,4),pilarEvents[e].lvl=1,e++;break;case 9:pilarEvents[e].setPosition(r,t+2),pilarEvents[e].set_frame("!dalle",6,2,6),pilarEvents[e].lvl=2,e++;break;case 10:pilarEvents[e].setPosition(r,t+3),pilarEvents[e].set_frame("!dalle",6,2,8),pilarEvents[e].lvl=3,e++;break;case 11:cCountFreeSlot++}}pilarEvents=pilarEvents.slice(0,e),switchEvents=switchEvents.slice(0,a),$gameMap.changeTileset(2)},initChar=function(e,a){e.active=!1,e.lvl=0,e.canJump=a,e.exit=!1,behindPilar=!1,cantMove=!1,fixPriority=!1},initTile=function(e,a){e.image=a,e.isSet=!1,e.lvl=0,e.active=!1,this.newDir=0},door={},blueTile={},purpleTile={},greenTile={},yellowTile={},blueChar={},purpleChar={},greenChar={},yellowChar={},playerChar=Object.create(Game_Event.prototype),cArrayTeamMembers=[blueChar,purpleChar,greenChar,yellowChar],allPilars=[],tileIdKey=[],cGameInit=function(){$gameScreen.startFadeOut(1),blueChar=$gameMap.event(cGetId("blue")),purpleChar=$gameMap.event(cGetId("purple")),greenChar=$gameMap.event(cGetId("green")),yellowChar=$gameMap.event(cGetId("yellow")),nbOfChar=4,blueTile=$gameMap.event(cGetId("dalle_bleu")),purpleTile=$gameMap.event(cGetId("dalle_violet")),greenTile=$gameMap.event(cGetId("dalle_vert")),yellowTile=$gameMap.event(cGetId("dalle_jaune")),switchEvents=[],pilarEvents=[],cacheTile=$gameMap.event(cGetId("cache")),initChar(blueChar,!1),initChar(purpleChar,!1),initChar(greenChar,!0),initChar(yellowChar,!1),initChar(playerChar,!1),cArrayTeamMembers=[blueChar,purpleChar,greenChar,yellowChar],initTile(blueTile,["!dalle",1,1,2]),initTile(purpleTile,["!dalle",1,2,2]),initTile(greenTile,["!dalle",1,3,2]),initTile(yellowTile,["!dalle",2,1,2]),cGetPilars(),cGetMapElements(),blueChar.ownSwitch=blueSwitch,purpleChar.ownSwitch=purpleSwitch,greenChar.ownSwitch=greenSwitch,yellowChar.ownSwitch=yellowSwitch,playerChar.ownSwitch={},blueChar.ownTile=blueTile,purpleChar.ownTile=purpleTile,greenChar.ownTile=greenTile,yellowChar.ownTile=yellowTile,playerChar.ownTile={},allPilars=pilarEvents.concat(switchEvents.concat([blueTile,purpleTile,greenTile,yellowTile])),tileIdKey=[];for(var e=0;e<allPilars.length;e++){for(j=0;j<=allPilars[e].lvl;j++)tileIdKey.push([allPilars[e].x,allPilars[e].y-j]);tempChar=whosThere(allPilars[e].x,allPilars[e].y-allPilars[e].lvl,0),void 0!==tempChar&&(tempChar.lvl=Math.min(1,allPilars[e].lvl)),allPilars[e].orig_x=allPilars[e].x,allPilars[e].orig_y=allPilars[e].y,allPilars[e].setPriorityType(0===allPilars[e].lvl?0:allPilars[e].y)}if(door=$gameMap.event(cGetId("door")),door.open=!1,mapNumber=mapOrder.indexOf($gameMap.mapId()),0===mapOrder.length)for(var e=0;e<$dataMapInfos.length;e++)null!==$dataMapInfos[e]&&(mapOrder[Number($dataMapInfos[e].name.slice(-3))]=$dataMapInfos[e].id);allowSwap=!1,allowMove=!1,cUpdatePos(),playerChar=blueChar,$gameScreen.startFadeIn(50),$dataMap.note.length!==mapNumber&&Utils()},setMyCharPriority=function(){for(var e=0;e<cArrayTeamMembers.length;e++)if(chara=cArrayTeamMembers[e],charaPilar=onPilar(chara),!chara.fixPriority)switch(chara.lvl){case 0:chara.setPriorityType(chara.y);break;case 1:void 0!==charaPilar[0]&&(chara.behindPilar&&chara.setPriorityType(charaPilar[charaPilar.length-1].orig_y+1),chara.behindPilar||chara.setPriorityType(charaPilar[0].orig_y+5))}},allTilesSet=function(){return blueTile.isSet&&purpleTile.isSet&&greenTile.isSet&&yellowTile.isSet?!0:!1},cUpdatePos=function(){var e=PilarsXY(playerChar.x,playerChar.y);playerChar.behindPilar=void 0!==e[0]&&e[0].y>playerChar.y&&e[0].y-e[0].lvl<playerChar.y||playerChar.behindPilar&&playerChar.cantMove?!0:!1,playerChar.x!==door.x||playerChar.y!==door.y||playerChar.exit||exitChar(),playerChar.onPilar=onPilar(playerChar).length>0?onPilar(playerChar)[0]:void 0,setMyCharPriority(),$gamePlayer.setPriorityType(playerChar._priorityType),cIconBlueTile.cActive=tileSelection&&playerChar===purpleChar&&onSwitch(playerChar)&&cCountFreeSlot>0&&!blueTile.isSet,cIconPurpleTile.cActive=tileSelection&&playerChar===purpleChar&&onSwitch(playerChar)&&cCountFreeSlot>0&&!purpleTile.isSet,cIconGreenTile.cActive=tileSelection&&playerChar===purpleChar&&onSwitch(playerChar)&&cCountFreeSlot>0&&!greenTile.isSet,cIconYellowTile.cActive=tileSelection&&playerChar===purpleChar&&onSwitch(playerChar)&&cCountFreeSlot>0&&!yellowTile.isSet,cIconJump.cActive=fCanJumpFront()||fCanAssistJumpFront(),cIconCancel.cActive=tileSelection||tileControl,cIconConfirm.cActive=tileControl,onSwitch(playerChar)&&playerChar.ownTile.isSet&&!tileSelection&&!tileControl?cIconUp.cActive=!0:cIconUp.cActive=!1,onSwitch(playerChar)&&playerChar.ownTile.isSet&&!tileSelection&&!tileControl?cIconDown.cActive=!0:cIconDown.cActive=!1,playerChar===purpleChar&&onSwitch(playerChar)&&!tileSelection&&playerChar.active&&cCountFreeSlot>0&&!allTilesSet()?cIconSetTile.cActive=!0:cIconSetTile.cActive=!1,cIconSwitch.cActive===!0&&allowSwap?$gameScreen.showPicture(cIconSwitch.cImageId,cIconSwitch.cImage,1,cIconSwitch.cPos[0],cIconSwitch.cPos[1],25,25,swapMode?255:50,0):$gameScreen.erasePicture(cIconSwitch.cImageId),cIconBlueChar.cActive===!0&&allowSwap?$gameScreen.showPicture(cIconBlueChar.cImageId,cIconBlueChar.cImage,1,cIconBlueChar.cPos[0],cIconBlueChar.cPos[1],100,100,playerChar.eventId()===blueChar.eventId()&&playerChar.active?255:50,0):$gameScreen.erasePicture(cIconBlueChar.cImageId),cIconPurpleChar.cActive===!0&&allowSwap?$gameScreen.showPicture(cIconPurpleChar.cImageId,cIconPurpleChar.cImage,1,cIconPurpleChar.cPos[0],cIconPurpleChar.cPos[1],100,100,playerChar.eventId()===purpleChar.eventId()&&playerChar.active?255:50,0):$gameScreen.erasePicture(cIconPurpleChar.cImageId),cIconGreenChar.cActive===!0&&allowSwap?$gameScreen.showPicture(cIconGreenChar.cImageId,cIconGreenChar.cImage,1,cIconGreenChar.cPos[0],cIconGreenChar.cPos[1],100,100,playerChar.eventId()===greenChar.eventId()&&playerChar.active?255:50,0):$gameScreen.erasePicture(cIconGreenChar.cImageId),cIconYellowChar.cActive===!0&&allowSwap?$gameScreen.showPicture(cIconYellowChar.cImageId,cIconYellowChar.cImage,1,cIconYellowChar.cPos[0],cIconYellowChar.cPos[1],100,100,playerChar.eventId()===yellowChar.eventId()&&playerChar.active?255:50,0):$gameScreen.erasePicture(cIconYellowChar.cImageId),cIconRetry.cActive===!0&&allowSwap?$gameScreen.showPicture(cIconRetry.cImageId,cIconRetry.cImage,1,cIconRetry.cPos[0],cIconRetry.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconRetry.cImageId),cIconSetTile.cActive!==!0||blueTile.isSet?$gameScreen.erasePicture(cIconBlueTile0.cImageId):$gameScreen.showPicture(cIconBlueTile0.cImageId,cIconBlueTile0.cImage,1,cIconSetTile.cPos[0],cIconSetTile.cPos[1]-16,70,70,255,0),cIconSetTile.cActive!==!0||purpleTile.isSet?$gameScreen.erasePicture(cIconPurpleTile0.cImageId):$gameScreen.showPicture(cIconPurpleTile0.cImageId,cIconPurpleTile0.cImage,1,cIconSetTile.cPos[0]-16,cIconSetTile.cPos[1],70,70,255,0),cIconSetTile.cActive!==!0||greenTile.isSet?$gameScreen.erasePicture(cIconGreenTile0.cImageId):$gameScreen.showPicture(cIconGreenTile0.cImageId,cIconGreenTile0.cImage,1,cIconSetTile.cPos[0]+16,cIconSetTile.cPos[1],70,70,255,0),cIconSetTile.cActive!==!0||yellowTile.isSet?$gameScreen.erasePicture(cIconYellowTile0.cImageId):$gameScreen.showPicture(cIconYellowTile0.cImageId,cIconYellowTile0.cImage,1,cIconSetTile.cPos[0],cIconSetTile.cPos[1]+16,70,70,255,0),cIconJump.cActive===!0?$gameScreen.showPicture(cIconJump.cImageId,cIconJump.cImage,1,cIconJump.cPos[0],cIconJump.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconJump.cImageId),cIconBlueTile.cActive===!0?$gameScreen.showPicture(cIconBlueTile.cImageId,cIconBlueTile.cImage,1,cIconBlueTile.cPos[0],cIconBlueTile.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconBlueTile.cImageId),cIconPurpleTile.cActive===!0?$gameScreen.showPicture(cIconPurpleTile.cImageId,cIconPurpleTile.cImage,1,cIconPurpleTile.cPos[0],cIconPurpleTile.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconPurpleTile.cImageId),cIconGreenTile.cActive===!0?$gameScreen.showPicture(cIconGreenTile.cImageId,cIconGreenTile.cImage,1,cIconGreenTile.cPos[0],cIconGreenTile.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconGreenTile.cImageId),cIconYellowTile.cActive===!0?$gameScreen.showPicture(cIconYellowTile.cImageId,cIconYellowTile.cImage,1,cIconYellowTile.cPos[0],cIconYellowTile.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconYellowTile.cImageId),cIconCancel.cActive===!0?$gameScreen.showPicture(cIconCancel.cImageId,cIconCancel.cImage,1,cIconCancel.cPos[0],cIconCancel.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconCancel.cImageId),cIconConfirm.cActive===!0?$gameScreen.showPicture(cIconConfirm.cImageId,cIconConfirm.cImage,1,cIconConfirm.cPos[0],cIconConfirm.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconConfirm.cImageId),cIconUp.cActive===!0?$gameScreen.showPicture(cIconUp.cImageId,cIconUp.cImage,1,cIconUp.cPos[0],cIconUp.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconUp.cImageId),cIconDown.cActive===!0?$gameScreen.showPicture(cIconDown.cImageId,cIconDown.cImage,1,cIconDown.cPos[0],cIconDown.cPos[1],100,100,255,0):$gameScreen.erasePicture(cIconDown.cImageId),wallDown.cActive===!0?$gameScreen.showPicture(wallDown.cImageId,wallDown.cImage,0,wallDown.cPos[0],wallDown.cPos[1],100,100,255,0):$gameScreen.erasePicture(wallDown.cImageId)},fCharNear=function(e,a,r){var t=[];switch(r){case 0:t=[4===e.direction()?-a:6===e.direction()?a:0,8===e.direction()?-a:2===e.direction()?a:0];break;case 2:t=[0,a];break;case 8:t=[0,-a];break;case 4:t=[-a,0];break;case 6:t=[a,0]}return whosThere(e.x+t[0],e.y+t[1],e.lvl)},dirVect=function(e,a){switch(e){case 0:return[4===a.direction()?-1:6===a.direction()?1:0,8===a.direction()?-1:2===a.direction()?1:0];case 2:return[0,1];case 8:return[0,-1];case 4:return[-1,0];case 6:return[1,0]}},fHoleNear=function(e,a,r){var t=[];switch(r){case 0:t=[4===e.direction()?-a:6===e.direction()?a:0,8===e.direction()?-a:2===e.direction()?a:0];break;case 2:t=[0,a];break;case 8:t=[0,-a];break;case 4:t=[-a,0];break;case 6:t=[a,0]}return 3===myTileId(e.x+t[0],e.y+t[1])},myTileId=function(e,a){for(var r=0;r<tileIdKey.length;r++)if(e===tileIdKey[r][0]&&a===tileIdKey[r][1])return $gameMap.tileId(e,a,2);return 129===$gameMap.tileId(e,a,3)?$gameMap.tileId(e,a,2):$gameMap.tileId(e,a,3)},cSwitchPlayer=function(){if(!allowSwap)return!0;return $gameTemp.clearDestination(),charSelected=closestChar(TouchInput.x,TouchInput.y),void 0!==charSelected?(swapChar(charSelected),!0):!1},swapChar=function(e){e.exit||(playerChar.active&&($gameMap.event(playerChar.eventId()).forceMoveRoute({list:[{code:0}],repeat:!1,skippable:!0,wait:!1}),$gameMap.event(playerChar.eventId()).setMoveSpeed(4),$gameMap.event(playerChar.eventId()).setDirection($gamePlayer.direction()),$gameMap.event(playerChar.eventId()).setPosition($gamePlayer.x,$gamePlayer.y),$gameMap.event(playerChar.eventId()).setTransparent(!1),$gameMap.event(playerChar.eventId()).setThrough(!1)),$gamePlayer.setThrough(!1),$gamePlayer.setTransparent(!1),$gamePlayer.setMoveSpeed(5),$gameActors.actor(1).setCharacterImage(e.characterName(),e.characterIndex()),$gamePlayer.reserveTransfer($gameMap.mapId(),e.x,e.y,e.direction(),2),e.setDirectionFix(!1),e.setWalkAnime(!0),e.forceMoveRoute({list:[{code:29,indent:null,parameters:[7]},{code:39,indent:null,parameters:[]},{code:37,indent:null,parameters:[]},{code:10,indent:null,parameters:[]},{code:45,indent:null,parameters:["this.setDirection($gamePlayer.direction())"]},{code:0,indent:null,parameters:[]}],repeat:!0,skippable:!0,wait:!1}),$gamePlayer.forceMoveRoute({list:[{code:15,indent:null,parameters:[1]},{code:43,indent:null,parameters:[1]},{code:15,indent:null,parameters:[2]},{code:43,indent:null,parameters:[0]},{code:0,indent:null,parameters:[]}],repeat:!1,skippable:!0,wait:!1}),playerChar=e,playerChar.active=!0,swapMode=!1)},cMyPassibility=function(e,a,r,t){var i=whosThere(e,a,r),l=whatsThere(e,a,r);if(void 0!==i||void 0!==l&&0===r||playerChar.cantMove)return!1;if(e===door.x&&a===door.y&&0===r&&door.open)return!0;if(1>=e||2>=a&&0===r||e>=21||a>=13)return!1;if(r>0){if(playerChar.behindPilar&&8===t)return!1;var c=(PilarsXY(e,a),void 0!==Pilars[0]&&Pilars[0].y-Pilars[0].lvl===a),n=(4===t||6===t)&&void 0!==Pilars[Pilars.length-1]&&Pilars[Pilars.length-1].y-Pilars[Pilars.length-1].lvl===a;if(c||n)return!0}else if(3!==myTileId(e,a))return!0;return!1},firstTap=!1;Scene_Map.prototype.processMapTouch=function(){if(wait1=!1,wait2=!1,allowMove&&!$gameSwitches.value(1)&&(TouchInput.isTriggered()||this._touchCount>0)&&void 0!==closestChar(TouchInput.x,TouchInput.y)&&closestChar(TouchInput.x,TouchInput.y)!==playerChar)if(TouchInput.isPressed())void 0!==closestChar(TouchInput.x,TouchInput.y)&&closestChar(TouchInput.x,TouchInput.y)!==playerChar&&(wait1=!0,this._touchCount>10&&cSwitchPlayer()),this._touchCount++;else{var e=$gameMap.canvasToMapX(TouchInput.x),a=$gameMap.canvasToMapY(TouchInput.y);(e>1&&(a>2||1===playerChar.lvl)&&21>e||e===door.x&&a===door.y)&&$gameTemp.setDestination(e,a),this._touchCount=0}if(allowMove&&!wait1&&!wait2&&(TouchInput.isTriggered()||this._touchCount>0))if(TouchInput.isPressed()){if(0===this._touchCount||this._touchCount>=15){var e=$gameMap.canvasToMapX(TouchInput.x),a=$gameMap.canvasToMapY(TouchInput.y);(e>1&&(a>2||1===playerChar.lvl)&&21>e||e===door.x&&a===door.y)&&$gameTemp.setDestination(e,a)}this._touchCount++}else this._touchCount=0};var delaiDT;Game_Event.prototype.update=function(){Game_Character.prototype.update.call(this),this.checkEventTriggerAuto(),this.updateParallel()},Game_Player.prototype.moveByInput=function(){if(!this.isMoving()&&this.canMove()&&allowMove){var e=this.getInputDirection();if(e>0)$gameTemp.clearDestination();else if($gameTemp.isDestinationValid()){var a=$gameTemp.destinationX(),r=$gameTemp.destinationY();e=this.findDirectionTo(a,r)}e>0&&this.executeMove(e)}};var fJump=function(){charAhead=fCharNear(playerChar,1,0),$gamePlayer.forceMoveRoute({list:[{code:15,indent:null,parameters:[3]},{code:45,indent:null,parameters:["if(fCanJumpFront())$gamePlayer.jump_forward(2);"]},{code:0,indent:null,parameters:[]}],repeat:!1,skippable:!0,wait:!1}),fCanAssistJumpFront()&&charAhead.jump_forward(2)},fCanJumpFront=function(){var e=dirVect(0,playerChar);return playerChar.canJump?0===playerChar.lvl&&fHoleNear(playerChar,1,0)&&!fHoleNear(playerChar,2,0)&&!fCharNear(playerChar,2,0)&&cMyPassibility(playerChar.x+2*e[0],playerChar.y+2*e[1],playerChar.lvl)?!0:1!==playerChar.lvl||fCharNear(playerChar,1,0)||cMyPassibility(playerChar.x+e[0],playerChar.y+e[1],playerChar.lvl)||!cMyPassibility(playerChar.x+2*e[0],playerChar.y+2*e[1],playerChar.lvl)?!1:!0:!1},fCanAssistJumpFront=function(){if(!playerChar.canJump)return!1;var e;e=fCharNear(playerChar,1,0);var a=void 0!==e?dirVect(0,e):void 0;return 0===playerChar.lvl&&void 0!==e&&fHoleNear(e,1,0)&&!fHoleNear(e,2,0)&&!fCharNear(e,2,0)&&cMyPassibility(e.x+2*a[0],e.y+2*a[1],playerChar.lvl)?!0:1===playerChar.lvl&&void 0!==e&&!cMyPassibility(e.x+a[0],e.y+a[1],playerChar.lvl)&&cMyPassibility(e.x+2*a[0],e.y+2*a[1],playerChar.lvl)?!0:!1},fSetTile=function(e){var a;switch(e){case blueTile:a=0;case purpleTile:a=1;case greenTile:a=2;case yellowTile:a=3}var r=e.image;allowSwap=!1,playerChar.active&&($gameMap.event(playerChar.eventId()).forceMoveRoute({list:[{code:0}],repeat:!1,skippable:!0,wait:!1}),$gameMap.event(playerChar.eventId()).setMoveSpeed(4),$gameMap.event(playerChar.eventId()).setDirection($gamePlayer.direction()),$gameMap.event(playerChar.eventId()).setPosition($gamePlayer.x,$gamePlayer.y),$gameMap.event(playerChar.eventId()).setTransparent(!1),$gameMap.event(playerChar.eventId()).setThrough(!1)),blueChar.active=!1,purpleChar.active=!1,greenChar.active=!1,yellowChar.active=!1,playerChar.active=!1,e.set_frame(r[0],r[1],r[2],r[3]),$gameActors.actor(1).setCharacterImage("",0),$gamePlayer.reserveTransfer($gameMap.mapId(),11,3,0,2),e.setThrough(!0),e.setMoveSpeed(6),e.setPosition(11,3),$gamePlayer.setMoveSpeed(6),$gamePlayer.setThrough(!0),e.forceMoveRoute({list:[{code:35,indent:null,parameters:[]},{code:45,indent:null,parameters:["if(TouchInput.isPressed() && touchInGame(TouchInput.x,TouchInput.y))this.setPosition(Math.floor(TouchInput.x/48),Math.floor(TouchInput.y/48));"]},{code:45,indent:null,parameters:["if(Input.isPressed('up')){this.moveStraight(8)}else if(Input.isPressed('left')){this.moveStraight(4)}else if(Input.isPressed('right')){this.moveStraight(6)}else if(Input.isPressed('down')){this.moveStraight(2)}"]},{code:0,indent:null,parameters:[]}],repeat:!0,skippable:!0,wait:!1}),e.active=!0},touchInGame=function(e,a){var r=Math.floor(e/48),t=Math.floor(a/48);return 21>r&&r>1&&t>2&&11===myTileId(r,t)?!0:!1},fCancelSetTile=function(){var e=blueTile.active?blueTile:purpleTile.active?purpleTile:greenTile.active?greenTile:yellowTile.active?yellowTile:void 0;e.set_frame(e.image[0],4,2,2),e.forceMoveRoute({list:[{code:0}],repeat:!1,skippable:!0,wait:!1}),e.setPosition(0,0),tileControl=!1,e.active=!1,allowSwap=!0,swapChar(purpleChar)},fConfirmSetTile=function(){var e=blueTile.active?blueTile:purpleTile.active?purpleTile:greenTile.active?greenTile:yellowTile.active?yellowTile:void 0;11===myTileId(e.x,e.y)&&(fCheckSlot(blueTile,e.x,e.y)||fCheckSlot(purpleTile,e.x,e.y)||fCheckSlot(greenTile,e.x,e.y)||fCheckSlot(yellowTile,e.x,e.y)||(e.forceMoveRoute({list:[{code:0}],repeat:!1,skippable:!0,wait:!1}),tileControl=!1,e.active=!1,allowSwap=!0,e.isSet=!0,e.setThrough(!1),e.orig_x=e.x,e.orig_y=e.y,cCountFreeSlot--,swapChar(purpleChar)))},fCheckSlot=function(e,a,r){return e.isSet&&e.x===a&&e.y===r?!0:!1},onSwitch=function(e){return playerChar.active&&e.x===e.ownSwitch.x&&e.y===e.ownSwitch.y-e.ownSwitch.lvl&&(0===e.lvl&&0===e.ownSwitch.lvl||e.lvl>0&&e.ownSwitch.lvl>0)?!0:!1},whosThere=function(e,a,r){for(var t=0;t<cArrayTeamMembers.length;t++)if(cArrayTeamMembers[t].x===e&&cArrayTeamMembers[t].y===a&&cArrayTeamMembers[t].lvl===r)return cArrayTeamMembers[t]},whatsThere=function(e,a,r){for(var t=0;t<allPilars.length;t++)if(allPilars[t].x===e&&allPilars[t].y===a&&allPilars[t].lvl>r)return allPilars[t]},moveTileUp=function(){if(tile=playerChar.ownTile,!tileMoving&&(charOn=whosThere(tile.x,tile.y-tile.lvl,0===tile.lvl?0:1),void 0===charOn||void 0===whosThere(tile.x,tile.y-tile.lvl-1,1))){switch(charOn=void 0===charOn||charOn._priorityType!==tile._priorityType+(charOn.behindPilar?1:5)&&0!==tile.lvl?void 0:charOn,tile.direction()){case 2:tile.newDir=4;break;case 4:tile.newDir=6;break;case 6:tile.newDir=8;break;case 8:return}tileMoving=!0,cacheFunction(tile.x,tile.y+1),cacheTile.setPosition(tile.x,tile.y+1),tile.setMoveSpeed(3),tile.setThrough(!0),cUpdatePos(),tile.setPriorityType(tile.y),cacheTile.setPriorityType(tile._priorityType),void 0!==charOn&&(charOn.cantMove=!1,PilarsXY(charOn.x,charOn.y-1).length>0&&(highPilar=PilarsXY(charOn.x,charOn.y-1)[0],lowPilar=PilarsXY(charOn.x,charOn.y-1)[PilarsXY(charOn.x,charOn.y-1).length-1],charOn.behindPilar=highPilar.y-highPilar.lvl<charOn.y&&highPilar.y>tile.y?!0:!1,charOn.cantMove=highPilar.y-highPilar.lvl===charOn.y-1&&highPilar.y>tile.y?!0:!1),charOn.fixPriority=!0,0===charOn.lvl&&(charOn._priorityType+=1),charOn.lvl=1),tile.lvl++,tile.setPosition(tile.x,tile.y+1),tile.set_frame(tile.image[0],tile.image[1],tile.image[2],tile.newDir),void 0!==charOn&&(charOn.setThrough(!0),charOn.setMoveSpeed(tile.moveSpeed()),charOn.setDirectionFix(!0),charOn.setWalkAnime(!1),charOn.lvl=1,charOn.forceMoveRoute({list:[{code:4,indent:null,parameters:[]},{code:45,indent:null,parameters:["charOn.fixPriority=false;"]},{code:38,indent:null,parameters:[]},{code:0,indent:null,parameters:[]}],repeat:!1,skippable:!0,wait:!1})),playerChar.ownTile.forceMoveRoute({list:[{code:4,indent:null,parameters:[]},{code:38,indent:null,parameters:[]},{code:45,indent:null,parameters:["tileMoving=false;"]},{code:0,indent:null,parameters:[]}],repeat:!1,skippable:!0,wait:!0})}};setAllPilarsTransp=function(e){for(var a=0;a<allPilars.length-1;a++)allPilars[a].lvl>0&&allPilars[a].setOpacity(e)};var tileMoving=!1,moveTileDown=function(){if(tile=playerChar.ownTile,!tileMoving&&(charOn=whosThere(tile.x,tile.y-tile.lvl,0===tile.lvl?0:1),void 0===whosThere(tile.x,tile.y-tile.lvl+1,1)||!whosThere(tile.x,tile.y-tile.lvl+1,1).behindPilar)){switch(charOn=void 0!==charOn&&charOn._priorityType===tile._priorityType+(charOn.behindPilar?1:5)?charOn:void 0,tile.direction()){case 2:return;case 4:tile.newDir=2;break;case 6:tile.newDir=4;break;case 8:tile.newDir=6}tileMoving=!0,cacheFunction(tile.x,tile.y+1),cacheTile.setPosition(tile.x,tile.y+1),cacheTile.setPriorityType(tile._priorityType),tile.setMoveSpeed(3),tile.setThrough(!0),void 0!==charOn&&PilarsXY(charOn.x,charOn.y+1).length>0&&(highPilar=PilarsXY(charOn.x,charOn.y+1)[0],lowPilar=PilarsXY(charOn.x,charOn.y+1)[PilarsXY(charOn.x,charOn.y+1).length-1],charOn.behindPilar=highPilar.y-highPilar.lvl<=charOn.y+1&&highPilar.y>tile.y?!0:!1,charOn.cantMove=highPilar.y-highPilar.lvl===charOn.y+1&&2!==tile.newDir?!0:!1,cUpdatePos(),charOn.fixPriority=!0),charBelow=whosThere(tile.x,tile.y-tile.lvl,0===tile.lvl?0:1),void 0===charOn&&void 0!==charBelow&&(charBelow.cantMove=!1,charBelow.fixPriority=!0,charBelow.behindPilar=!1),cUpdatePos(),playerChar.ownTile.forceMoveRoute({list:[{code:1,indent:null,parameters:[]},{code:45,indent:null,parameters:["tile.set_frame(tile.image[0],tile.image[1],tile.image[2],tile.newDir);tile.setPosition(tile.x,tile.y-1);if(tile.newDir===2)tile.setPriorityType(0);tile.lvl --;tileMoving=false;if(charBelow!==undefined)charBelow.fixPriority=false;"]},{code:38,indent:null,parameters:[]},{code:0,indent:null,parameters:[]}],repeat:!1,skippable:!0,wait:!1}),void 0!==charOn&&(charOn.setThrough(!0),charOn.setMoveSpeed(tile.moveSpeed()),charOn.setDirectionFix(!0),charOn.setWalkAnime(!1),cUpdatePos(),charOn.forceMoveRoute({list:[{code:1,indent:null,parameters:[]},{code:45,indent:null,parameters:["charOn.lvl= (tile.newDir===2)?0:1;charOn.fixPriority=false;"]},{code:38,indent:null,parameters:[]},{code:0,indent:null,parameters:[]}],repeat:!1,skippable:!0,wait:!0}))}},cacheFunction=function(e,a){switch(myTileId(e,a)){case 1:cacheTile.set_frame("!cache",1,1,2);break;case 2:cacheTile.set_frame("!cache",1,2,2);break;case 3:cacheTile.set_frame("!cache",1,3,2);break;case 11:cacheTile.set_frame("!cache",2,1,2)}},mapNumber=1,exitChar=function(){chara=playerChar,chara.exit=!0,chara.setTransparent(!0),chara.setPosition(0,0),blueChar.active=!1,purpleChar.active=!1,greenChar.active=!1,yellowChar.active=!1,playerChar.active=!1,$gameActors.actor(1).setCharacterImage("",0),$gamePlayer.reserveTransfer($gameMap.mapId(),0,0,0,2),nbOfChar--,blueChar.exit&&purpleChar.exit&&greenChar.exit&&yellowChar.exit&&(mapNumber++,$gameVariables.setValue(2,Math.max($gameVariables.value(2),mapNumber)),DataManager.saveGame(1),wallDown.cActive=!1,$gamePlayer.reserveTransfer(mapOrder[mapNumber],0,0,0,0)),swapChar(blueChar.exit?purpleChar.exit?greenChar.exit?yellowChar:greenChar:purpleChar:blueChar)},sortNumber=function(e,a){return e-a},closestChar=function(e,a){var r=Math.sqrt(Math.pow(48*blueChar.x+24-e,2)+Math.pow(48*blueChar.y+24-a,2)),t=Math.sqrt(Math.pow(48*purpleChar.x+24-e,2)+Math.pow(48*purpleChar.y+24-a,2)),i=Math.sqrt(Math.pow(48*greenChar.x+24-e,2)+Math.pow(48*greenChar.y+24-a,2)),l=Math.sqrt(Math.pow(48*yellowChar.x+24-e,2)+Math.pow(48*yellowChar.y+24-a,2)),c=Math.min(r,t,i,l);if(!(c>50))switch(c){case r:return blueChar;case t:return purpleChar;case i:return greenChar;case l:return yellowChar}},distance=function(e,a,r,t){return Math.sqrt(Math.pow(e-r,2)+Math.pow(a-t,2))},onPilar=function(e){return onPilars=[],lowest=whatsThere(e.x,e.y+3,0),middle=whatsThere(e.x,e.y+2,0),highest=whatsThere(e.x,e.y+1,0),void 0!==lowest&&e.y===lowest.orig_y-lowest.lvl&&onPilars.push(lowest),void 0!==middle&&e.y===middle.orig_y-middle.lvl&&onPilars.push(middle),void 0!==highest&&e.y===highest.orig_y-highest.lvl&&onPilars.push(highest),onPilars},PilarsXY=function(e,a){return Pilars=[],lowest=whatsThere(e,a+3,0),middle=whatsThere(e,a+2,0),highest=whatsThere(e,a+1,0),highest2=whatsThere(e,a,0),void 0!==lowest&&lowest.y-lowest.lvl<=a&&Pilars.push(lowest),void 0!==middle&&middle.y-middle.lvl<=a&&Pilars.push(middle),void 0!==highest&&highest.y-highest.lvl<=a&&Pilars.push(highest),Pilars},charOnPilar=function(e){return whosThere(e.x,e.y-e.lvl,1)},oldTransfer=Game_Player.prototype.performTransfer,newTransfer=function(){this.isTransferring()&&(this.setDirection(this._newDirection),$gameMap.setup(this._newMapId),this._needsMapReload=!1,this.locate(this._newX,this._newY),this.refresh(),this.clearTransferInfo())},setRetry=function(){retry=!0,Game_Player.prototype.performTransfer=newTransfer,playerChar.active=!1,$gameActors.actor(1).setCharacterImage("",0),$gameMap.setupEvents(),$gamePlayer.reserveTransfer($gameMap.mapId(),0,0,0,0),Game_Player.prototype.performTransfer=oldTransfer};Game_Player.prototype.isDebugThrough=function(){};